---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-gstat - GEOM統計レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 該当なし

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/gstat/gstat.c` 54-56行目（グローバルフラグ）
- E-02: `usr.sbin/gstat/gstat.c` 76-613行目（main関数全体）
- E-03: `usr.sbin/gstat/gstat.c` 350-375行目（devstat_compute_statistics）
- E-04: `usr.sbin/gstat/gstat.c` 58-59行目（ビジー率閾値）
- E-05: `usr.sbin/gstat/gstat.c` 60-65行目（PRINTMSGマクロ）
- E-06: `usr.sbin/gstat/gstat.c` 615-621行目（usage関数）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devstat_compute_statisticsで16種類のDSM統計値取得 | E-03 (350-375行目) | ○ |
| C-02 | ビジー率80%超で赤、50%超でマゼンタ、それ以下で緑 | E-04, E-02 (509-514行目) | ○ |
| C-03 | isattyが偽で自動バッチモード | E-02 (107-108行目) | ○ |
| C-04 | -fオプションでregex正規表現フィルタ | E-02 (137-142行目, 337-339行目) | ○ |
| C-05 | -Iオプションでマイクロ秒単位の更新間隔指定 | E-02 (145-157行目) | ○ |
| C-06 | libeditによるインタラクティブフィルタ入力 | E-02 (188-201行目, 564-594行目) | ○ |
| C-07 | sequence0!=sequence1でデータスキップ | E-02 (341-348行目) | ○ |
| C-08 | -cオプションでコンシューマも表示 | E-02 (322-323行目) | ○ |
| C-09 | -pオプションでrank=1プロバイダのみ | E-02 (324-327行目) | ○ |
| C-10 | -CオプションでCSV出力（ヘッダー付き） | E-02 (280-303行目) | ○ |
| C-11 | CSVモードでタイムスタンプ付き | E-02 (226-231行目, 398-399行目) | ○ |
| C-12 | -sオプションで転送サイズカラム追加 | E-02 (262-265行目, 404-406行目) | ○ |
| C-13 | -dオプションでdelete操作カラム追加 | E-02 (270-276行目) | ○ |
| C-14 | -oオプションでother操作カラム追加 | E-02 (277-278行目) | ○ |
| C-15 | コンシューマ名はclass/geom/provider形式 | E-02 (389-396行目) | ○ |
| C-16 | レイテンシ値の動的精度（>1e3:0桁, >1e0:1桁, 他:3桁） | E-02 (407-412行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 単一ファイルで完結し、全処理をソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] GEOMトポロジ変更時のgeom_deletetree/geom_gettree再構築処理（314-317行目）の安全性を確認
- [ ] curses画面とlibeditの連携時の端末状態復元処理（580-584行目）を確認
- [ ] -aオプション（ビジー率0.1%未満スキップ）の閾値妥当性を確認
